/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import CH.ifa.draw.figures.RectangleFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import DE.siemens.ad.logo.app.action.CompositeUndoableAction;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.dialog.SpacePanel;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.action.MoveFigureAction;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.pdraw.util.FigureXPositionComparator;
import DE.siemens.ad.udf.LogoDrawingUDF;
import DE.siemens.ad.udf.LogoDrawingViewUDF;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;

public class SpaceHorizontalAction
extends CompositeUndoableAction {
    private static final long serialVersionUID = -2901642684059701718L;

    public SpaceHorizontalAction() {
        this.putValue("Name", "AlignSpaceAcross");
        this.putValue("textKey", "format.align.spaceacross");
        this.putValue("SmallIcon", Global.getIcon("AlignSpace.gif"));
        this.putValue("ShortDescription", Language.getStringNoTilde("format.align.spaceacross", "Horizontally distribute space"));
    }

    public void moveToXPosition(Figure figure, int Dx) {
        MoveFigureAction moveAction = null;
        moveAction = new MoveFigureAction();
        moveAction.setOwner(this.getOwner());
        moveAction.setFigure(figure);
        moveAction.setMoveVector(new Dimension(Dx, 0));
        this.children.add(moveAction);
    }

    public boolean prepareAction() {
        SpacePanel spacePanel = new SpacePanel();
        SplittedDlg dialog = SplittedDlg.create(null, spacePanel, 3);
        dialog.show();
        if (dialog.getControlPanel().getResult() != 1) {
            return false;
        }
        DrawingView view = ((LogoComfort)this.getOwner()).view();
        Vector<BlockFigure> selectedBlockFigures = new Vector<BlockFigure>();
        Enumeration selectedFigures = view.selection().elements();
        Figure f = null;
        while (selectedFigures.hasMoreElements()) {
            f = (Figure)selectedFigures.nextElement();
            if (!(f instanceof BlockFigure)) continue;
            selectedBlockFigures.add((BlockFigure)f);
        }
        this.children.removeAllElements();
        Collections.sort(selectedBlockFigures, new FigureXPositionComparator());
        int lastX = ((BlockFigure)selectedBlockFigures.elementAt((int)0)).getImageFigure().displayBox().x - spacePanel.getSpace();
        for (int i = 0; i < selectedBlockFigures.size(); ++i) {
            int curSpace = ((BlockFigure)selectedBlockFigures.get((int)i)).getImageFigure().displayBox().x - lastX;
            this.moveToXPosition((Figure)selectedBlockFigures.get(i), spacePanel.getSpace() - curSpace);
            lastX += spacePanel.getSpace() + this.getFigureWidthWithGridSupports(view, (BlockFigure)selectedBlockFigures.elementAt(0));
        }
        if (view instanceof LogoDrawingViewUDF) {
            int maxX = lastX + ((BlockFigure)selectedBlockFigures.lastElement()).displayBox().width;
            RectangleFigure udfBox = ((LogoDrawingUDF)view.drawing()).getEditUDFFigure().getUDFBoxFigure();
            if (udfBox.displayBox().x + udfBox.displayBox().width < maxX) {
                udfBox.displayBox(new Point(udfBox.displayBox().x, udfBox.displayBox().y), new Point(maxX, udfBox.displayBox().y + udfBox.displayBox().height));
            }
        }
        return super.prepareAction();
    }

    private int getFigureWidthWithGridSupports(DrawingView view, BlockFigure figure) {
        if (((LogoDrawingView)view).getGridInfo().gridAttractionIsOn()) {
            int gridDistance = ((LogoDrawingView)view).getGridInfo().getDistance();
            return (figure.getImageFigure().displayBox().width + gridDistance - 1) / gridDistance * gridDistance;
        }
        return figure.getImageFigure().displayBox().width;
    }
}

